/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.client.gui.screen;

import com.quickskin.mod.client.services.LocalAssetManager;
import com.quickskin.mod.common.data.AssetMetadata;
import com.quickskin.mod.common.data.KnownCapes;
import com.quickskin.mod.common.data.TextureQuality;
import java.nio.file.Path;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class CapeEntry {
    private final AssetMetadata localCape;
    private final KnownCapes knownCape;
    private final boolean isLocal;

    private CapeEntry(AssetMetadata localCape, KnownCapes knownCape, boolean isLocal) {
        this.localCape = localCape;
        this.knownCape = knownCape;
        this.isLocal = isLocal;
    }

    public static CapeEntry fromLocal(AssetMetadata metadata) {
        return new CapeEntry(metadata, null, true);
    }

    public static CapeEntry fromKnown(KnownCapes cape) {
        return new CapeEntry(null, cape, false);
    }

    public boolean isLocal() {
        return this.isLocal;
    }

    public boolean isKnown() {
        return !this.isLocal;
    }

    @Nullable
    public AssetMetadata getLocalCape() {
        return this.localCape;
    }

    @Nullable
    public KnownCapes getKnownCape() {
        return this.knownCape;
    }

    public String getFriendlyName() {
        if (this.isLocal) {
            return this.localCape != null ? this.localCape.friendlyName() : "Unknown";
        }
        return this.knownCape != null ? this.knownCape.getDisplayName() : "Unknown";
    }

    public String getDescription() {
        if (this.isLocal) {
            return "Custom cape";
        }
        return this.knownCape != null ? this.knownCape.getDescription() : "Unknown";
    }

    public boolean isAnimated() {
        if (this.isLocal) {
            return this.localCape != null && this.localCape.isAnimated();
        }
        return this.knownCape != null && this.knownCape.isAnimated();
    }

    @Nullable
    public ResourceLocation getTextureLocation() {
        if (this.isLocal) {
            return this.localCape != null ? LocalAssetManager.getInstance().getTextureLocation(this.localCape.hash(), TextureQuality.FULL) : null;
        }
        return this.knownCape != null ? this.knownCape.getTextureLocation() : null;
    }

    public String getCapeId() {
        if (this.isLocal) {
            return this.localCape != null ? "local_cape:" + this.localCape.hash() : "";
        }
        return this.knownCape != null ? "known:" + this.knownCape.getId() : "";
    }

    @Nullable
    public Path getPath() {
        return this.isLocal && this.localCape != null ? this.localCape.path() : null;
    }

    public boolean isCustom() {
        if (this.isLocal) {
            return true;
        }
        return this.knownCape != null && this.knownCape.isCustom();
    }
}

