/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.client.gui.screen;

import com.mojang.blaze3d.platform.InputConstants;
import com.quickskin.mod.client.gui.effect.BlurHandler;
import com.quickskin.mod.client.gui.screen.PlayerCapeMenuScreen;
import com.quickskin.mod.client.gui.screen.PlayerSkinMenuScreen;
import com.quickskin.mod.client.gui.util.ButtonFactory;
import com.quickskin.mod.client.gui.widget.TabButton;
import com.quickskin.mod.client.input.KeybindRegistry;
import com.quickskin.mod.client.services.PlayerAppearanceService;
import com.quickskin.mod.config.ClientConfig;
import com.quickskin.mod.config.ServerConfig;
import com.quickskin.mod.networking.ClientNetworkHandler;
import com.quickskin.mod.networking.ModNetworking;
import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class SettingsScreen
extends Screen {
    @Nullable
    private final Screen parent;
    private static final int PANEL_BG = -1342177280;
    private static final int PANEL_OUTLINE = 0x60FFFFFF;
    private static final int TAB_HEIGHT = 30;
    private static final int TAB_WIDTH = 100;
    private static final int TAB_SPACING = 2;
    private int dialogX;
    private int dialogY;
    private int dialogWidth = 480;
    private int dialogHeight = 280;
    private Tab activeTab = Tab.CLIENT;
    private TabButton guiEditTabButton;
    private TabButton clientTabButton;
    private TabButton serverTabButton;
    private TabButton modpackTabButton;
    private final List<AbstractWidget> guiEditSettingWidgets = new ArrayList<AbstractWidget>();
    private final List<AbstractWidget> clientSettingWidgets = new ArrayList<AbstractWidget>();
    private final List<AbstractWidget> serverSettingWidgets = new ArrayList<AbstractWidget>();
    private final List<AbstractWidget> modpackSettingWidgets = new ArrayList<AbstractWidget>();
    private Checkbox showOverlayCheckbox;
    private Checkbox disableSkinTransparencyCheckbox;
    private Checkbox enableStyledButtonsCheckbox;
    private Checkbox enablePlayerPreviewCustomizationCheckbox;
    private Button keybindButton;
    @Nullable
    private KeyMapping selectedKey;
    private Checkbox serverDisableSkinTransparencyCheckbox;
    private EditBox skinChangeCooldownEditBox;
    private Checkbox enablePlayerOwnSkinSystemCheckbox;
    private boolean needsTextureReload = false;

    public SettingsScreen(@Nullable Screen parent) {
        super((Component)Component.m_237113_((String)"QuickSkin Settings"));
        this.parent = parent;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.guiEditSettingWidgets.clear();
        this.clientSettingWidgets.clear();
        this.serverSettingWidgets.clear();
        this.modpackSettingWidgets.clear();
        this.dialogWidth = Math.min(480, this.f_96543_ - 40);
        this.dialogHeight = Math.min(280, this.f_96544_ - 40);
        this.dialogX = (this.f_96543_ - this.dialogWidth) / 2;
        int tabY = this.dialogY = (this.f_96544_ - this.dialogHeight) / 2;
        int tabStartX = this.dialogX;
        this.clientTabButton = (TabButton)ButtonFactory.createTab(tabStartX, tabY, 100, 30, (Component)Component.m_237113_((String)Tab.CLIENT.getDisplayName()), this.activeTab == Tab.CLIENT, btn -> this.switchTab(Tab.CLIENT));
        this.m_142416_((GuiEventListener)this.clientTabButton);
        this.guiEditTabButton = (TabButton)ButtonFactory.createTab(tabStartX + 100 + 2, tabY, 100, 30, (Component)Component.m_237113_((String)Tab.GUI_EDIT.getDisplayName()), this.activeTab == Tab.GUI_EDIT, btn -> this.switchTab(Tab.GUI_EDIT));
        this.m_142416_((GuiEventListener)this.guiEditTabButton);
        this.modpackTabButton = (TabButton)ButtonFactory.createTab(tabStartX + 204, tabY, 100, 30, (Component)Component.m_237113_((String)Tab.MODPACK.getDisplayName()), this.activeTab == Tab.MODPACK, btn -> this.switchTab(Tab.MODPACK));
        this.m_142416_((GuiEventListener)this.modpackTabButton);
        this.serverTabButton = (TabButton)ButtonFactory.createTab(tabStartX + 306, tabY, 100, 30, (Component)Component.m_237113_((String)Tab.SERVER.getDisplayName()), this.activeTab == Tab.SERVER, btn -> this.switchTab(Tab.SERVER));
        this.m_142416_((GuiEventListener)this.serverTabButton);
        this.createGuiEditSettings();
        this.createClientSettings();
        this.createServerSettings();
        this.createModpackSettings();
        Button doneButton = ButtonFactory.createPrimary(this.dialogX + this.dialogWidth / 2 - 50, this.dialogY + this.dialogHeight - 30, 100, 20, (Component)Component.m_237113_((String)"Done"), btn -> this.m_7379_());
        this.m_142416_((GuiEventListener)doneButton);
        this.switchTab(this.activeTab);
    }

    private void createGuiEditSettings() {
        ClientConfig config = ClientConfig.getInstance();
        int checkboxSize = 20;
        int spacing = 30;
        int startY = this.dialogY + 30 + 20;
        int leftColumnX = this.dialogX + 20;
        int currentY = startY;
        this.showOverlayCheckbox = new Checkbox(leftColumnX, currentY, checkboxSize, checkboxSize, (Component)Component.m_237113_((String)"Enable mini player preview ingame"), config.showSkinPreviewOverlay);
        this.guiEditSettingWidgets.add((AbstractWidget)this.showOverlayCheckbox);
        this.enableStyledButtonsCheckbox = new Checkbox(leftColumnX, currentY += spacing, checkboxSize, checkboxSize, (Component)Component.m_237113_((String)"Enable Styled Buttons"), config.enableStyledButtons);
        this.guiEditSettingWidgets.add((AbstractWidget)this.enableStyledButtonsCheckbox);
        this.enablePlayerPreviewCustomizationCheckbox = new Checkbox(leftColumnX, currentY += spacing, checkboxSize, checkboxSize, (Component)Component.m_237113_((String)"Enable Preview Customization"), config.enablePlayerPreviewCustomization);
        this.guiEditSettingWidgets.add((AbstractWidget)this.enablePlayerPreviewCustomizationCheckbox);
    }

    private void createClientSettings() {
        ClientConfig config = ClientConfig.getInstance();
        int checkboxSize = 20;
        int spacing = 30;
        int startY = this.dialogY + 30 + 20;
        int leftColumnX = this.dialogX + 20;
        int rightColumnX = this.dialogX + this.dialogWidth / 2 + 10;
        int currentLeftY = startY;
        int currentRightY = startY;
        int keybindButtonWidth = 75;
        int keybindButtonSpacing = 5;
        this.keybindButton = ButtonFactory.createStyled(leftColumnX, currentLeftY, keybindButtonWidth, 20, KeybindRegistry.OPEN_SKIN_MENU.m_90863_(), button -> {
            this.selectedKey = KeybindRegistry.OPEN_SKIN_MENU;
        });
        this.clientSettingWidgets.add((AbstractWidget)this.keybindButton);
        this.clientSettingWidgets.add(new AbstractWidget(leftColumnX + keybindButtonWidth + keybindButtonSpacing, currentLeftY, 100, 20, (Component)Component.m_237113_((String)"Open Skin Menu")){

            public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                guiGraphics.m_280430_(Minecraft.m_91087_().f_91062_, this.m_6035_(), this.m_252754_(), this.m_252907_() + (this.f_93619_ - 8) / 2, 0xE0E0E0);
            }

            public void m_168797_(NarrationElementOutput narrationElementOutput) {
                narrationElementOutput.m_169146_(NarratedElementType.TITLE, this.m_6035_());
            }

            public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
                return false;
            }
        });
        this.disableSkinTransparencyCheckbox = new Checkbox(rightColumnX, currentRightY, checkboxSize, checkboxSize, (Component)Component.m_237113_((String)"Disable Skin Transparency"), config.disableSkinTransparency);
        this.clientSettingWidgets.add((AbstractWidget)this.disableSkinTransparencyCheckbox);
    }

    private void createServerSettings() {
        ServerConfig config = ServerConfig.getInstance();
        int checkboxSize = 20;
        int spacing = 30;
        int startY = this.dialogY + 30 + 20;
        int leftColumnX = this.dialogX + 20;
        int currentY = startY;
        boolean isAdmin = this.f_96541_ != null && this.f_96541_.f_91074_ != null && this.f_96541_.f_91074_.m_20310_(2);
        ServerConfig serverOverride = ClientConfig.getInstance().getServerOverride();
        boolean currentTransparencySetting = serverOverride != null ? serverOverride.disableSkinTransparency : false;
        this.serverDisableSkinTransparencyCheckbox = new Checkbox(leftColumnX, currentY, checkboxSize, checkboxSize, (Component)Component.m_237113_((String)"Disable Skin Transparency (Server)"), currentTransparencySetting);
        this.serverDisableSkinTransparencyCheckbox.f_93623_ = isAdmin;
        this.serverSettingWidgets.add((AbstractWidget)this.serverDisableSkinTransparencyCheckbox);
        int editBoxWidth = 60;
        int editBoxSpacing = 5;
        this.skinChangeCooldownEditBox = new EditBox(this.f_96547_, leftColumnX, currentY += spacing, editBoxWidth, 20, (Component)Component.m_237113_((String)"Skin Change Cooldown"));
        this.skinChangeCooldownEditBox.m_94144_(String.valueOf(config.skinChangeCooldownSeconds));
        this.skinChangeCooldownEditBox.m_94199_(5);
        this.skinChangeCooldownEditBox.m_94153_(text -> text.isEmpty() || text.matches("\\d+"));
        this.skinChangeCooldownEditBox.f_93623_ = isAdmin;
        this.serverSettingWidgets.add((AbstractWidget)this.skinChangeCooldownEditBox);
        this.serverSettingWidgets.add(new AbstractWidget(leftColumnX + editBoxWidth + editBoxSpacing, currentY, 200, 20, (Component)Component.m_237113_((String)"Skin Change Cooldown (seconds)")){

            public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                guiGraphics.m_280430_(Minecraft.m_91087_().f_91062_, this.m_6035_(), this.m_252754_(), this.m_252907_() + (this.f_93619_ - 8) / 2, 0xE0E0E0);
            }

            public void m_168797_(NarrationElementOutput narrationElementOutput) {
                narrationElementOutput.m_169146_(NarratedElementType.TITLE, this.m_6035_());
            }

            public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
                return false;
            }
        });
    }

    private void createModpackSettings() {
        ClientConfig config = ClientConfig.getInstance();
        int checkboxSize = 20;
        int startY = this.dialogY + 30 + 20;
        int leftColumnX = this.dialogX + 20;
        this.enablePlayerOwnSkinSystemCheckbox = new Checkbox(leftColumnX, startY, checkboxSize, checkboxSize, (Component)Component.m_237113_((String)"Enable Player's Own Skin System"), config.enablePlayerOwnSkinSystem);
        this.enablePlayerOwnSkinSystemCheckbox.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)"When enabled, automatically downloads your Mojang skin and protects it from being deleted. Disable for modpacks where all players should use provided skins.")));
        this.modpackSettingWidgets.add((AbstractWidget)this.enablePlayerOwnSkinSystemCheckbox);
    }

    private void switchTab(Tab tab) {
        this.activeTab = tab;
        for (AbstractWidget widget : this.guiEditSettingWidgets) {
            this.m_169411_((GuiEventListener)widget);
        }
        for (AbstractWidget widget : this.clientSettingWidgets) {
            this.m_169411_((GuiEventListener)widget);
        }
        for (AbstractWidget widget : this.serverSettingWidgets) {
            this.m_169411_((GuiEventListener)widget);
        }
        for (AbstractWidget widget : this.modpackSettingWidgets) {
            this.m_169411_((GuiEventListener)widget);
        }
        List<AbstractWidget> activeWidgets = switch (tab.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> this.guiEditSettingWidgets;
            case 1 -> this.clientSettingWidgets;
            case 2 -> this.serverSettingWidgets;
            case 3 -> this.modpackSettingWidgets;
        };
        for (AbstractWidget widget : activeWidgets) {
            this.m_142416_((GuiEventListener)widget);
        }
        this.guiEditTabButton.setSelected(tab == Tab.GUI_EDIT);
        this.clientTabButton.setSelected(tab == Tab.CLIENT);
        this.serverTabButton.setSelected(tab == Tab.SERVER);
        this.modpackTabButton.setSelected(tab == Tab.MODPACK);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        if (this.parent != null) {
            this.parent.m_88315_(graphics, -1, -1, partialTick);
        }
        graphics.m_280262_();
        BlurHandler.renderBlur();
        if (this.selectedKey == KeybindRegistry.OPEN_SKIN_MENU) {
            this.keybindButton.m_93666_((Component)Component.m_237113_((String)"> ").m_7220_((Component)Component.m_237113_((String)"???").m_130940_(ChatFormatting.YELLOW)).m_130946_(" <"));
        } else {
            this.keybindButton.m_93666_(KeybindRegistry.OPEN_SKIN_MENU.m_90863_());
        }
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_(0.0f, 0.0f, 100.0f);
        graphics.m_280509_(0, 0, this.f_96543_, this.f_96544_, 0x60000000);
        int contentPanelY = this.dialogY + 30;
        int contentPanelHeight = this.dialogHeight - 30;
        graphics.m_280509_(this.dialogX, contentPanelY, this.dialogX + this.dialogWidth, contentPanelY + contentPanelHeight, -1342177280);
        this.drawPanelOutline(graphics, this.dialogX, contentPanelY, this.dialogWidth, contentPanelHeight, 0x60FFFFFF);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        if (this.activeTab == Tab.SERVER && this.f_96541_ != null) {
            boolean isAdmin;
            boolean bl = isAdmin = this.f_96541_.f_91074_ != null && this.f_96541_.f_91074_.m_20310_(2);
            if (!isAdmin) {
                int noticeY = this.dialogY + this.dialogHeight - 55;
                String notice = "Only server admins can change these settings";
                int noticeWidth = this.f_96547_.m_92895_(notice);
                graphics.m_280056_(this.f_96547_, notice, this.dialogX + (this.dialogWidth - noticeWidth) / 2, noticeY, 0xFFCC00, false);
            }
        }
        graphics.m_280168_().m_85849_();
    }

    private void drawPanelOutline(GuiGraphics graphics, int x, int y, int width, int height, int color) {
        graphics.m_280509_(x, y, x + width, y + 1, color);
        graphics.m_280509_(x, y + height - 1, x + width, y + height, color);
        graphics.m_280509_(x, y, x + 1, y + height, color);
        graphics.m_280509_(x + width - 1, y, x + width, y + height, color);
    }

    private Screen recreateScreen(Screen screen) {
        if (screen instanceof PlayerSkinMenuScreen) {
            return new PlayerSkinMenuScreen(null);
        }
        if (screen instanceof PlayerCapeMenuScreen) {
            return new PlayerCapeMenuScreen(null);
        }
        return screen;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.selectedKey != null) {
            this.selectedKey.m_90848_(InputConstants.Type.MOUSE.m_84895_(button));
            KeyMapping.m_90854_();
            this.selectedKey = null;
            return true;
        }
        if (mouseX < (double)this.dialogX || mouseX > (double)(this.dialogX + this.dialogWidth) || mouseY < (double)this.dialogY || mouseY > (double)(this.dialogY + this.dialogHeight)) {
            this.m_7379_();
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        return false;
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (mouseX >= (double)this.dialogX && mouseX <= (double)(this.dialogX + this.dialogWidth) && mouseY >= (double)this.dialogY && mouseY <= (double)(this.dialogY + this.dialogHeight)) {
            return super.m_6050_(mouseX, mouseY, delta);
        }
        return false;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.selectedKey != null) {
            if (keyCode == 256) {
                this.selectedKey.m_90848_(InputConstants.f_84822_);
            } else {
                this.selectedKey.m_90848_(InputConstants.m_84827_((int)keyCode, (int)scanCode));
            }
            KeyMapping.m_90854_();
            this.selectedKey = null;
            return true;
        }
        if (keyCode == 256) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_7861_() {
        super.m_7861_();
        BlurHandler.cleanup();
        if (this.needsTextureReload) {
            PlayerAppearanceService.getInstance().reloadSkinsForTransparencyChange();
        }
    }

    public void m_7379_() {
        if (this.selectedKey != null) {
            KeyMapping.m_90854_();
            this.selectedKey = null;
        }
        ClientNetworkHandler.executePendingTransparencyReload();
        if (this.showOverlayCheckbox != null) {
            ClientConfig config = ClientConfig.getInstance();
            boolean oldTransparencySetting = config.disableSkinTransparency;
            boolean oldStyledButtonsSetting = config.enableStyledButtons;
            config.showSkinPreviewOverlay = this.showOverlayCheckbox.m_93840_();
            config.disableSkinTransparency = this.disableSkinTransparencyCheckbox.m_93840_();
            config.enableStyledButtons = this.enableStyledButtonsCheckbox.m_93840_();
            config.enablePlayerPreviewCustomization = this.enablePlayerPreviewCustomizationCheckbox.m_93840_();
            config.enablePlayerOwnSkinSystem = this.enablePlayerOwnSkinSystemCheckbox.m_93840_();
            if (oldTransparencySetting != config.disableSkinTransparency) {
                this.needsTextureReload = true;
            }
            config.save();
            if (oldStyledButtonsSetting != config.enableStyledButtons && this.parent != null && this.f_96541_ != null) {
                Screen newParent = this.recreateScreen(this.parent);
                this.f_96541_.m_91152_(newParent);
                return;
            }
        }
        if (this.serverDisableSkinTransparencyCheckbox != null) {
            boolean isAdmin;
            boolean bl = isAdmin = this.f_96541_ != null && this.f_96541_.f_91074_ != null && this.f_96541_.f_91074_.m_20310_(2);
            if (isAdmin) {
                boolean oldValue;
                boolean newValue = this.serverDisableSkinTransparencyCheckbox.m_93840_();
                ServerConfig serverOverride = ClientConfig.getInstance().getServerOverride();
                boolean bl2 = oldValue = serverOverride != null ? serverOverride.disableSkinTransparency : false;
                if (newValue != oldValue) {
                    FriendlyByteBuf packet = new FriendlyByteBuf(Unpooled.buffer());
                    packet.m_130070_("disableSkinTransparency");
                    packet.writeBoolean(newValue);
                    NetworkManager.sendToServer((ResourceLocation)ModNetworking.UPDATE_SERVER_CONFIG, (FriendlyByteBuf)packet);
                }
            }
            if (isAdmin && this.skinChangeCooldownEditBox != null && !this.skinChangeCooldownEditBox.m_94155_().isEmpty()) {
                try {
                    int cooldownSeconds = Integer.parseInt(this.skinChangeCooldownEditBox.m_94155_());
                    if (cooldownSeconds >= 0 && cooldownSeconds <= 86400) {
                        ServerConfig config = ServerConfig.getInstance();
                        config.skinChangeCooldownSeconds = cooldownSeconds;
                        config.save();
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        if (this.f_96541_ != null) {
            this.f_96541_.m_91152_(this.parent);
        }
    }

    private static enum Tab {
        GUI_EDIT("GUI Edit"),
        CLIENT("Client"),
        SERVER("Server"),
        MODPACK("Modpack");

        private final String displayName;

        private Tab(String displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }
}

