/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.client.gui.widget;

import com.quickskin.mod.QuickSkin;
import com.quickskin.mod.client.rendering.PlayerModelRenderer;
import com.quickskin.mod.client.rendering.PreviewPlayerData;
import com.quickskin.mod.client.services.AnimatedTextureManager;
import com.quickskin.mod.client.services.CapeService;
import com.quickskin.mod.client.services.LocalAssetManager;
import com.quickskin.mod.common.data.AnimationMetadata;
import com.quickskin.mod.config.ClientConfig;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class PlayerWidget
extends AbstractWidget {
    private final PreviewPlayerData previewData;
    private float bodyYaw = 20.0f;
    private float targetYRotation = 20.0f;
    private float scale = 87.2f;
    private static final float DEFAULT_SCALE = 87.2f;
    private static final float MIN_SCALE = 20.0f;
    private static final float MAX_SCALE = 200.0f;
    private static final float SCALE_STEP = 3.0f;
    private static final float PIVOT_OFFSET = 0.0f;
    private boolean isDragging = false;
    private int dragStartX = 0;
    private int dragStartY = 0;
    private int dragStartOffsetX = 0;
    private int dragStartOffsetY = 0;
    private boolean isRotating = false;
    private int rotationDragStartX = 0;
    private float rotationDragStartYaw = 0.0f;
    private float originalYRotation = 20.0f;
    private boolean shouldReturnToOriginal = false;
    private static final float ROTATION_SENSITIVITY = 0.5f;
    private int cachedModelCenterX = 0;
    private int cachedModelCenterY = 0;
    private float cachedScale = 87.2f;
    private WidgetContext context = WidgetContext.OTHER;
    private Button autoButton = null;
    private Button classicButton = null;
    private Button slimButton = null;
    private Integer customCenterX = null;
    private Integer customCenterY = null;
    private List<AbstractWidget> priorityWidgets = new ArrayList<AbstractWidget>();
    private static PlayerWidget activeInteractionWidget = null;
    private static final double DEFAULT_OFFSET_FROM_BUTTON_Y = -15.0;

    public PlayerWidget(int x, int y, int width, int height, @Nullable ResourceLocation skinLocation, @Nullable ResourceLocation capeLocation, @Nullable String capeId, String modelType) {
        super(x, y, width, height, (Component)Component.m_237119_());
        this.previewData = new PreviewPlayerData();
        this.previewData.setSkinLocation(skinLocation != null ? skinLocation : new ResourceLocation("minecraft", "textures/entity/player/wide/steve.png"));
        this.previewData.setCapeLocation(capeLocation);
        this.previewData.setCapeId(capeId);
        this.previewData.setModelType(modelType != null ? modelType : "classic");
        this.f_93624_ = true;
        this.f_93623_ = true;
    }

    private int getModelCenterX() {
        ClientConfig config = ClientConfig.getInstance();
        int offsetX = this.getPositionOffsetXFromConfig(config);
        if (this.customCenterX != null) {
            return this.customCenterX + offsetX;
        }
        if (this.autoButton != null && this.slimButton != null) {
            int leftEdge = this.autoButton.m_252754_();
            int rightEdge = this.slimButton.m_252754_() + this.slimButton.m_5711_();
            int middleX = (leftEdge + rightEdge) / 2;
            return middleX + offsetX;
        }
        if (this.classicButton != null && this.slimButton != null) {
            int classicCenterX = this.classicButton.m_252754_() + this.classicButton.m_5711_() / 2;
            int slimCenterX = this.slimButton.m_252754_() + this.slimButton.m_5711_() / 2;
            int middleX = (classicCenterX + slimCenterX) / 2;
            return middleX + offsetX;
        }
        return this.m_252754_() + this.m_5711_() / 2 + offsetX;
    }

    private int getBaseModelCenterY() {
        ClientConfig config = ClientConfig.getInstance();
        int offsetY = this.getPositionOffsetYFromConfig(config);
        if (this.customCenterY != null) {
            return this.customCenterY + offsetY;
        }
        if (this.classicButton != null) {
            int buttonCenterY = this.classicButton.m_252907_() + this.classicButton.m_93694_() / 2;
            return (int)((double)buttonCenterY + -15.0) + offsetY;
        }
        return this.m_252907_() + this.m_93694_() / 2 + 10 + offsetY;
    }

    private int getModelCenterY() {
        int baseY = this.getBaseModelCenterY();
        float pivotY = (float)baseY + 0.0f;
        float scaleRatio = this.scale / 87.2f;
        float offsetFromPivot = 0.0f * scaleRatio;
        return (int)(pivotY - offsetFromPivot);
    }

    public void setModelButtons(Button auto, Button classic, Button slim) {
        this.autoButton = auto;
        this.classicButton = classic;
        this.slimButton = slim;
    }

    public void setCustomReferencePoint(int centerX, int centerY) {
        this.customCenterX = centerX;
        this.customCenterY = centerY;
    }

    public void setContext(WidgetContext context) {
        this.context = context;
    }

    public void addPriorityWidget(AbstractWidget widget) {
        if (widget != null && !this.priorityWidgets.contains(widget)) {
            this.priorityWidgets.add(widget);
        }
    }

    public void clearPriorityWidgets() {
        this.priorityWidgets.clear();
    }

    private boolean isOverPriorityWidget(double mouseX, double mouseY) {
        for (AbstractWidget widget : this.priorityWidgets) {
            if (!widget.m_5953_(mouseX, mouseY)) continue;
            return true;
        }
        return false;
    }

    public static PlayerWidget getActiveInteractionWidget() {
        return activeInteractionWidget;
    }

    public boolean isInteracting() {
        return this.isDragging || this.isRotating;
    }

    private int getSliderPercentageFromConfig(ClientConfig config) {
        int defaultValue;
        int configValue;
        switch (this.context.ordinal()) {
            case 0: {
                configValue = config.sizeModelPreviewPercentageTitleScreen;
                defaultValue = 30;
                break;
            }
            case 1: {
                configValue = config.sizeModelPreviewPercentageSkinMenu;
                defaultValue = 51;
                break;
            }
            case 2: {
                configValue = config.sizeModelPreviewPercentageCapeMenu;
                defaultValue = 51;
                break;
            }
            case 3: {
                configValue = config.sizeModelPreviewPercentagePauseMenu;
                defaultValue = 32;
                break;
            }
            default: {
                return 50;
            }
        }
        return configValue != 0 ? configValue : defaultValue;
    }

    private void saveSliderPercentageToConfig(int percentage) {
        ClientConfig config = ClientConfig.getInstance();
        switch (this.context.ordinal()) {
            case 0: {
                config.sizeModelPreviewPercentageTitleScreen = percentage;
                break;
            }
            case 1: {
                config.sizeModelPreviewPercentageSkinMenu = percentage;
                break;
            }
            case 2: {
                config.sizeModelPreviewPercentageCapeMenu = percentage;
                break;
            }
            case 3: {
                config.sizeModelPreviewPercentagePauseMenu = percentage;
                break;
            }
        }
        config.save();
        QuickSkin.LOGGER.info("Saved {}% to config for context: {}", (Object)percentage, (Object)this.context);
    }

    private int getPositionOffsetXFromConfig(ClientConfig config) {
        return switch (this.context.ordinal()) {
            case 0 -> config.positionOffsetXTitleScreen;
            case 1 -> config.positionOffsetXSkinMenu;
            case 2 -> config.positionOffsetXCapeMenu;
            case 3 -> config.positionOffsetXPauseMenu;
            default -> 0;
        };
    }

    private int getPositionOffsetYFromConfig(ClientConfig config) {
        return switch (this.context.ordinal()) {
            case 0 -> config.positionOffsetYTitleScreen;
            case 1 -> config.positionOffsetYSkinMenu;
            case 2 -> config.positionOffsetYCapeMenu;
            case 3 -> config.positionOffsetYPauseMenu;
            default -> 0;
        };
    }

    private void savePositionOffsetsToConfig(int offsetX, int offsetY) {
        ClientConfig config = ClientConfig.getInstance();
        switch (this.context.ordinal()) {
            case 0: {
                config.positionOffsetXTitleScreen = offsetX;
                config.positionOffsetYTitleScreen = offsetY;
                break;
            }
            case 1: {
                config.positionOffsetXSkinMenu = offsetX;
                config.positionOffsetYSkinMenu = offsetY;
                break;
            }
            case 2: {
                config.positionOffsetXCapeMenu = offsetX;
                config.positionOffsetYCapeMenu = offsetY;
                break;
            }
            case 3: {
                config.positionOffsetXPauseMenu = offsetX;
                config.positionOffsetYPauseMenu = offsetY;
                break;
            }
            case 4: {
                return;
            }
        }
        config.save();
        QuickSkin.LOGGER.info("Saved position offset ({}, {}) to config for context: {}", new Object[]{offsetX, offsetY, this.context});
    }

    public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        ClientConfig config = ClientConfig.getInstance();
        int savedPercentage = this.getSliderPercentageFromConfig(config);
        float percentageAsFloat = (float)(savedPercentage - 1) / 99.0f;
        this.scale = 20.0f + percentageAsFloat * 180.0f;
        if (this.previewData.getCapeId() != null && this.previewData.getCapeLocation() != null) {
            AnimatedTextureManager animManager;
            String capeId = this.previewData.getCapeId();
            String animationId = null;
            if (capeId.startsWith("local_cape:")) {
                animationId = "cape_" + capeId.substring("local_cape:".length());
            } else if (capeId.startsWith("known:")) {
                animationId = "cape_known_" + capeId.substring("known:".length());
            }
            if (animationId != null && !(animManager = AnimatedTextureManager.getInstance()).isAnimated(animationId)) {
                if (capeId.startsWith("local_cape:")) {
                    String hash = capeId.substring("local_cape:".length());
                    AnimationMetadata metadata = LocalAssetManager.getInstance().getAnimationMetadata(hash);
                    BufferedImage atlasImage = LocalAssetManager.getInstance().getSourceImage(hash);
                    if (metadata != null && atlasImage != null) {
                        QuickSkin.LOGGER.debug("[PlayerWidget] On-demand registration of local cape animation: {}", (Object)animationId);
                        animManager.registerAnimation(animationId, capeId, this.previewData.getCapeLocation(), atlasImage, metadata);
                    }
                } else if (capeId.startsWith("known:")) {
                    String knownId = capeId.substring("known:".length());
                    QuickSkin.LOGGER.debug("[PlayerWidget] On-demand registration of known cape animation: {}", (Object)knownId);
                    CapeService.getInstance().loadKnownCape(knownId);
                }
            }
        }
        AnimatedTextureManager animManager = AnimatedTextureManager.getInstance();
        animManager.tick();
        if (this.shouldReturnToOriginal && !this.isRotating) {
            float diff = this.originalYRotation - this.targetYRotation;
            if (Math.abs(diff) > 0.1f) {
                this.targetYRotation += diff * 0.08f;
            } else {
                this.targetYRotation = this.originalYRotation;
                this.shouldReturnToOriginal = false;
            }
        }
        if (Math.abs(this.targetYRotation - this.bodyYaw) > 0.1f) {
            float diff = this.targetYRotation - this.bodyYaw;
            this.bodyYaw += diff * 0.15f;
        } else {
            this.bodyYaw = this.targetYRotation;
        }
        int modelCenterX = this.getModelCenterX();
        int modelCenterY = this.getModelCenterY();
        this.cachedModelCenterX = modelCenterX;
        this.cachedModelCenterY = modelCenterY;
        this.cachedScale = this.scale;
        this.previewData.setYRotation(this.bodyYaw);
        this.previewData.setHeadYaw(0.0f);
        this.previewData.setHeadPitch(0.0f);
        PlayerModelRenderer.renderPlayerModel(graphics, modelCenterX, modelCenterY, this.scale, this.bodyYaw, this.previewData, mouseX, mouseY, false);
        if (config.enablePlayerPreviewCustomization) {
            this.renderModelBorder(graphics, modelCenterX, modelCenterY, this.scale);
        }
    }

    private void renderModelBorder(GuiGraphics graphics, int centerX, int centerY, float scale) {
        int modelHeight = (int)(scale * 2.0f);
        int modelWidth = (int)((float)modelHeight * 0.6f);
        int left = centerX - modelWidth / 2;
        int right = centerX + modelWidth / 2;
        int top = centerY - modelHeight;
        Font font = Minecraft.m_91087_().f_91062_;
        ClientConfig config = ClientConfig.getInstance();
        String instructionText = config.enablePlayerPreviewCustomization ? "LMB: move | RMB: rotate | Wheel: resize" : "LMB/RMB drag: rotate";
        int textWidth = font.m_92895_(instructionText);
        int textX = centerX - textWidth / 2;
        int textY = top - 12;
        int textColor = -1;
        graphics.m_280056_(font, instructionText, textX, textY, textColor, true);
        int borderColor = -16711936;
        graphics.m_280509_(left, top, right, top + 2, borderColor);
        graphics.m_280509_(left, centerY - 2, right, centerY, borderColor);
        graphics.m_280509_(left, top, left + 2, centerY, borderColor);
        graphics.m_280509_(right - 2, top, right, centerY, borderColor);
        int crosshairSize = 5;
        int crosshairColor = -65536;
        graphics.m_280509_(centerX - crosshairSize, centerY - 1, centerX + crosshairSize, centerY + 1, crosshairColor);
        graphics.m_280509_(centerX - 1, centerY - crosshairSize, centerX + 1, centerY + crosshairSize, crosshairColor);
    }

    public void setSkin(@Nullable ResourceLocation skinLocation) {
        if (skinLocation != null) {
            this.previewData.setSkinLocation(skinLocation);
        }
    }

    public void setCape(@Nullable ResourceLocation capeLocation, @Nullable String capeId) {
        this.previewData.setCapeLocation(capeLocation);
        this.previewData.setCapeId(capeId);
    }

    public void setModelType(String modelType) {
        this.previewData.setModelType(modelType);
    }

    public void toggleRotation() {
        this.targetYRotation += 180.0f;
        this.originalYRotation += 180.0f;
        this.shouldReturnToOriginal = false;
    }

    public float getBodyYaw() {
        return this.bodyYaw;
    }

    public float getTargetYRotation() {
        return this.targetYRotation;
    }

    public void setRotationState(float bodyYaw, float targetYRotation) {
        this.bodyYaw = bodyYaw;
        this.targetYRotation = targetYRotation;
    }

    public void setAnimation(String animation) {
        if (animation != null && !animation.isEmpty()) {
            this.previewData.setCurrentAnimation(animation);
            QuickSkin.LOGGER.info("PlayerWidget animation set to: {}", (Object)animation);
        }
    }

    public String getAnimation() {
        return this.previewData.getCurrentAnimation();
    }

    public void m_5716_(double mouseX, double mouseY) {
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.isOverPriorityWidget(mouseX, mouseY)) {
            return false;
        }
        if (!this.m_5953_(mouseX, mouseY)) {
            return false;
        }
        ClientConfig config = ClientConfig.getInstance();
        if (button == 0) {
            if (config.enablePlayerPreviewCustomization) {
                this.isDragging = true;
                this.dragStartX = (int)mouseX;
                this.dragStartY = (int)mouseY;
                this.dragStartOffsetX = this.getPositionOffsetXFromConfig(config);
                this.dragStartOffsetY = this.getPositionOffsetYFromConfig(config);
                activeInteractionWidget = this;
                QuickSkin.LOGGER.info("Started dragging player preview at ({}, {})", (Object)mouseX, (Object)mouseY);
                return true;
            }
            this.isRotating = true;
            this.rotationDragStartX = (int)mouseX;
            this.rotationDragStartYaw = this.targetYRotation;
            this.shouldReturnToOriginal = false;
            activeInteractionWidget = this;
            QuickSkin.LOGGER.info("Started rotating player preview at ({}, {})", (Object)mouseX, (Object)mouseY);
            return true;
        }
        if (button == 1) {
            this.isRotating = true;
            this.rotationDragStartX = (int)mouseX;
            this.rotationDragStartYaw = this.targetYRotation;
            this.shouldReturnToOriginal = false;
            activeInteractionWidget = this;
            QuickSkin.LOGGER.info("Started rotating player preview at ({}, {})", (Object)mouseX, (Object)mouseY);
            return true;
        }
        return false;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        boolean handled = false;
        if (this.isDragging && button == 0) {
            this.isDragging = false;
            if (activeInteractionWidget == this) {
                activeInteractionWidget = null;
            }
            QuickSkin.LOGGER.info("Stopped dragging player preview at ({}, {})", (Object)mouseX, (Object)mouseY);
            handled = true;
        }
        if (this.isRotating && (button == 0 || button == 1)) {
            this.isRotating = false;
            this.shouldReturnToOriginal = true;
            if (activeInteractionWidget == this) {
                activeInteractionWidget = null;
            }
            QuickSkin.LOGGER.info("Stopped rotating player preview, returning to original rotation");
            handled = true;
        }
        return handled;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isDragging && button == 0) {
            int deltaX = (int)mouseX - this.dragStartX;
            int deltaY = (int)mouseY - this.dragStartY;
            int newOffsetX = this.dragStartOffsetX + deltaX;
            int newOffsetY = this.dragStartOffsetY + deltaY;
            this.savePositionOffsetsToConfig(newOffsetX, newOffsetY);
            return true;
        }
        if (this.isRotating && (button == 0 || button == 1)) {
            int deltaX = (int)mouseX - this.rotationDragStartX;
            float rotationDelta = (float)deltaX * 0.5f;
            this.targetYRotation = this.rotationDragStartYaw - rotationDelta;
            return true;
        }
        return false;
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        ClientConfig config = ClientConfig.getInstance();
        if (!config.enablePlayerPreviewCustomization) {
            return false;
        }
        if (!this.m_5953_(mouseX, mouseY)) {
            return false;
        }
        float oldScale = this.scale;
        this.scale += (float)delta * 3.0f;
        this.scale = Math.max(20.0f, Math.min(200.0f, this.scale));
        if (this.scale != oldScale) {
            float scaleRange = 180.0f;
            float currentScaleOffset = this.scale - 20.0f;
            int percentage = Math.round(currentScaleOffset / scaleRange * 99.0f) + 1;
            this.saveSliderPercentageToConfig(percentage);
        }
        return true;
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        if (this.isDragging || this.isRotating) {
            return true;
        }
        return !this.isMouseOutsideModelArea(mouseX, mouseY, this.cachedModelCenterX, this.cachedModelCenterY, this.cachedScale);
    }

    private boolean isMouseOutsideModelArea(double mouseX, double mouseY, int centerX, int centerY, float scale) {
        int modelHeight = (int)(scale * 2.0f);
        int modelWidth = (int)((float)modelHeight * 0.6f);
        int left = centerX - modelWidth / 2;
        int right = centerX + modelWidth / 2;
        int top = centerY - modelHeight;
        return mouseX < (double)left || mouseX > (double)right || mouseY < (double)top || mouseY > (double)centerY;
    }

    protected void m_168797_(NarrationElementOutput narrationElementOutput) {
        narrationElementOutput.m_169146_(NarratedElementType.TITLE, (Component)Component.m_237113_((String)"Player preview"));
    }

    public static enum WidgetContext {
        TITLE_SCREEN,
        SKIN_MENU,
        CAPE_MENU,
        PAUSE_MENU,
        OTHER;

    }
}

