/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.client.services;

import com.quickskin.mod.QuickSkin;
import com.quickskin.mod.client.services.AnimatedTextureManager;
import com.quickskin.mod.client.services.ICapeService;
import com.quickskin.mod.client.services.LocalAssetManager;
import com.quickskin.mod.client.storage.ClientAnimationMetadataCache;
import com.quickskin.mod.client.storage.NetworkTextureCache;
import com.quickskin.mod.common.data.AnimationMetadata;
import com.quickskin.mod.common.data.AssetMetadata;
import com.quickskin.mod.common.data.KnownCapes;
import com.quickskin.mod.common.data.TextureQuality;
import com.quickskin.mod.networking.NetworkSyncService;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.UUID;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class CapeService
implements ICapeService {
    private static CapeService instance;

    private CapeService() {
    }

    public static CapeService getInstance() {
        if (instance == null) {
            instance = new CapeService();
        }
        return instance;
    }

    public static void init() {
        CapeService.getInstance();
        QuickSkin.LOGGER.info("CapeService initialized");
    }

    @Override
    @Nullable
    public ResourceLocation getCapeLocation(UUID playerId, String capeId) {
        if (capeId == null || capeId.isEmpty()) {
            QuickSkin.LOGGER.debug("[CapeService] capeId is null or empty, returning null");
            return null;
        }
        if (capeId.startsWith("local_cape:")) {
            String hash = capeId.substring("local_cape:".length());
            return this.loadLocalCape(hash);
        }
        if (capeId.startsWith("known:")) {
            String knownId = capeId.substring("known:".length());
            return this.loadKnownCape(knownId);
        }
        return this.loadMojangCape(capeId);
    }

    @Override
    @Nullable
    public ResourceLocation loadMojangCape(String username) {
        QuickSkin.LOGGER.debug("Loading Mojang cape for: {}", (Object)username);
        QuickSkin.LOGGER.debug("Mojang cape loading requires online API access - not implemented yet");
        return null;
    }

    @Override
    @Nullable
    public ResourceLocation loadLocalCape(String hash) {
        ResourceLocation capeLocation;
        QuickSkin.LOGGER.debug("Loading local cape: {}", (Object)hash);
        if (NetworkTextureCache.getInstance().hasTexture(hash) && (capeLocation = NetworkTextureCache.getInstance().getTextureLocation(hash)) != null) {
            QuickSkin.LOGGER.debug("Loaded cape from network cache: {}", (Object)hash);
            AnimationMetadata animMeta = ClientAnimationMetadataCache.getInstance().getMetadata(hash);
            if (animMeta != null) {
                String animationId = "cape_" + hash;
                String capeId = "local_cape:" + hash;
                AnimatedTextureManager animManager = AnimatedTextureManager.getInstance();
                if (!animManager.isAnimated(animationId)) {
                    try {
                        byte[] textureData = NetworkTextureCache.getInstance().getTextureData(hash);
                        if (textureData != null) {
                            ByteArrayInputStream bais = new ByteArrayInputStream(textureData);
                            BufferedImage atlasImage = ImageIO.read(bais);
                            if (atlasImage != null) {
                                animManager.registerAnimation(animationId, capeId, capeLocation, atlasImage, animMeta);
                                QuickSkin.LOGGER.info("Registered animation for network cape: {}", (Object)hash);
                            } else {
                                QuickSkin.LOGGER.warn("Could not read image for network cape animation: {}", (Object)hash);
                            }
                        }
                    }
                    catch (Exception e) {
                        QuickSkin.LOGGER.error("Failed to register animation for network cape: {}", (Object)hash, (Object)e);
                    }
                }
            }
            return capeLocation;
        }
        capeLocation = LocalAssetManager.getInstance().getTextureLocation(hash, TextureQuality.FULL);
        if (capeLocation != null) {
            AssetMetadata assetMeta = LocalAssetManager.getInstance().getMetadata(hash);
            if (assetMeta != null && assetMeta.isAnimated()) {
                String animationId = "cape_" + hash;
                String capeId = "local_cape:" + hash;
                AnimatedTextureManager animManager = AnimatedTextureManager.getInstance();
                if (!animManager.isAnimated(animationId)) {
                    AnimationMetadata animMeta = LocalAssetManager.getInstance().getAnimationMetadata(hash);
                    BufferedImage atlasImage = LocalAssetManager.getInstance().getSourceImage(hash);
                    if (animMeta != null && atlasImage != null) {
                        animManager.registerAnimation(animationId, capeId, capeLocation, atlasImage, animMeta);
                        QuickSkin.LOGGER.info("Registered animation for local cape: {}", (Object)hash);
                    } else {
                        QuickSkin.LOGGER.warn("Could not register animation for local cape {}: metadata or image was null.", (Object)hash);
                    }
                }
            }
            QuickSkin.LOGGER.debug("Loaded local cape: {}", (Object)hash);
        } else {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91074_ != null && mc.m_91403_() != null) {
                QuickSkin.LOGGER.info("Cape {} not found locally, requesting from server", (Object)hash);
                NetworkSyncService.getInstance().requestTexture(mc.f_91074_.m_20148_(), "cape", hash);
            }
        }
        return capeLocation;
    }

    @Override
    @Nullable
    public ResourceLocation loadKnownCape(String capeId) {
        QuickSkin.LOGGER.debug("Loading known cape: {}", (Object)capeId);
        KnownCapes cape = KnownCapes.getById(capeId);
        if (cape != null && !cape.isNoCape()) {
            block10: {
                QuickSkin.LOGGER.debug("[CapeService] loadKnownCape: capeId={}, isAnimated={}", (Object)capeId, (Object)cape.isAnimated());
                if (cape.isAnimated()) {
                    String animationId = "cape_known_" + capeId;
                    AnimatedTextureManager animManager = AnimatedTextureManager.getInstance();
                    QuickSkin.LOGGER.info("[CapeService] Animation check: animationId={}, alreadyRegistered={}", (Object)animationId, (Object)animManager.isAnimated(animationId));
                    if (!animManager.isAnimated(animationId)) {
                        QuickSkin.LOGGER.info("[CapeService] Starting animation registration for: {}", (Object)capeId);
                        try {
                            ResourceLocation capeTexture = cape.getTextureLocation();
                            QuickSkin.LOGGER.info("[CapeService] Loading texture from: {}", (Object)capeTexture);
                            InputStream stream = ((Resource)Minecraft.m_91087_().m_91098_().m_213713_(capeTexture).get()).m_215507_();
                            BufferedImage atlasImage = ImageIO.read(stream);
                            stream.close();
                            QuickSkin.LOGGER.info("[CapeService] Image loaded: {}x{}", atlasImage != null ? Integer.valueOf(atlasImage.getWidth()) : "null", atlasImage != null ? Integer.valueOf(atlasImage.getHeight()) : "null");
                            if (atlasImage != null) {
                                int width = atlasImage.getWidth();
                                int height = atlasImage.getHeight();
                                int frameHeight = width / 2;
                                int frameCount = height / frameHeight;
                                QuickSkin.LOGGER.info("[CapeService] Calculated: width={}, height={}, frameHeight={}, frameCount={}", new Object[]{width, height, frameHeight, frameCount});
                                if (frameCount > 1) {
                                    ArrayList<AnimationMetadata.FrameData> frames = new ArrayList<AnimationMetadata.FrameData>();
                                    for (int i = 0; i < frameCount; ++i) {
                                        frames.add(new AnimationMetadata.FrameData(50, i));
                                    }
                                    AnimationMetadata metadata = new AnimationMetadata(frames, frameCount);
                                    QuickSkin.LOGGER.info("[CapeService] Calling registerAnimation...");
                                    String fullCapeId = "known:" + capeId;
                                    animManager.registerAnimation(animationId, fullCapeId, capeTexture, atlasImage, metadata);
                                    QuickSkin.LOGGER.info("[CapeService] SUCCESS! Registered animation for KnownCape: {} ({} frames)", (Object)capeId, (Object)frameCount);
                                } else {
                                    QuickSkin.LOGGER.warn("[CapeService] FAILED: frameCount <= 1, cannot register animation");
                                }
                                break block10;
                            }
                            QuickSkin.LOGGER.warn("[CapeService] FAILED: atlasImage is null");
                        }
                        catch (Exception e) {
                            QuickSkin.LOGGER.error("[CapeService] EXCEPTION during animation registration for: {}", (Object)capeId, (Object)e);
                        }
                    } else {
                        QuickSkin.LOGGER.info("[CapeService] Animation already registered, skipping");
                    }
                }
            }
            ResourceLocation location = cape.getTextureLocation();
            QuickSkin.LOGGER.debug("Found known cape {} at {}", (Object)capeId, (Object)location);
            return location;
        }
        QuickSkin.LOGGER.debug("Unknown cape ID: {}", (Object)capeId);
        return null;
    }

    @Override
    public boolean isAnimated(String capeId) {
        String knownId;
        KnownCapes cape;
        if (capeId == null || capeId.isEmpty()) {
            return false;
        }
        if (capeId.startsWith("local_cape:")) {
            String hash = capeId.substring("local_cape:".length());
            AssetMetadata metadata = LocalAssetManager.getInstance().getMetadata(hash);
            if (metadata != null && metadata.isAnimated()) {
                QuickSkin.LOGGER.debug("Cape {} is animated", (Object)hash);
                return true;
            }
        }
        if (capeId.startsWith("known:") && (cape = KnownCapes.getById(knownId = capeId.substring("known:".length()))) != null) {
            return cape.isAnimated();
        }
        return false;
    }
}

