/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.client.services;

import com.quickskin.mod.QuickSkin;
import com.quickskin.mod.client.services.ISkinService;
import com.quickskin.mod.client.services.LocalAssetManager;
import com.quickskin.mod.client.storage.NetworkTextureCache;
import com.quickskin.mod.common.data.TextureQuality;
import com.quickskin.mod.networking.NetworkSyncService;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class SkinService
implements ISkinService {
    private static SkinService instance;

    private SkinService() {
    }

    public static SkinService getInstance() {
        if (instance == null) {
            instance = new SkinService();
        }
        return instance;
    }

    public static void init() {
        SkinService.getInstance();
        QuickSkin.LOGGER.info("SkinService initialized");
    }

    @Override
    @Nullable
    public ResourceLocation getSkinLocation(UUID playerId, String skinId) {
        if (skinId == null || skinId.isEmpty()) {
            return null;
        }
        if (skinId.startsWith("local_skin:")) {
            String hash = skinId.substring("local_skin:".length());
            return this.loadLocalSkin(hash);
        }
        return this.loadMojangSkin(skinId);
    }

    @Override
    @Nullable
    public ResourceLocation loadMojangSkin(String username) {
        QuickSkin.LOGGER.debug("Loading Mojang skin for: {}", (Object)username);
        try {
            UUID uuid = UUID.nameUUIDFromBytes(("OfflinePlayer:" + username).getBytes(StandardCharsets.UTF_8));
            ResourceLocation defaultSkin = DefaultPlayerSkin.m_118627_((UUID)uuid);
            QuickSkin.LOGGER.debug("Using default skin for: {} (UUID: {})", (Object)username, (Object)uuid);
            return defaultSkin;
        }
        catch (Exception e) {
            QuickSkin.LOGGER.error("Failed to load Mojang skin for: {}", (Object)username, (Object)e);
            return null;
        }
    }

    @Override
    @Nullable
    public ResourceLocation loadLocalSkin(String hash) {
        ResourceLocation networkLocation;
        QuickSkin.LOGGER.debug("Loading local skin: {}", (Object)hash);
        if (NetworkTextureCache.getInstance().hasTexture(hash) && (networkLocation = NetworkTextureCache.getInstance().getTextureLocation(hash)) != null) {
            QuickSkin.LOGGER.debug("Loaded skin from network cache: {}", (Object)hash);
            return networkLocation;
        }
        ResourceLocation localLocation = LocalAssetManager.getInstance().getTextureLocation(hash, TextureQuality.FULL);
        if (localLocation == null) {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91074_ != null && mc.m_91403_() != null) {
                QuickSkin.LOGGER.info("Skin {} not found locally, requesting from server", (Object)hash);
                NetworkSyncService.getInstance().requestTexture(mc.f_91074_.m_20148_(), "skin", hash);
            }
        }
        return localLocation;
    }
}

