/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.client.storage;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.quickskin.mod.QuickSkin;
import com.quickskin.mod.client.services.LocalAssetManager;
import com.quickskin.mod.config.ClientConfig;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class LocalAppearanceStorage {
    private static LocalAppearanceStorage instance;
    private static final Gson GSON;
    private Path storageFile;

    private LocalAppearanceStorage() {
    }

    public static LocalAppearanceStorage getInstance() {
        if (instance == null) {
            instance = new LocalAppearanceStorage();
        }
        return instance;
    }

    public void init(Path configDirectory) {
        this.storageFile = configDirectory.resolve("quickskin_preferences.json");
        QuickSkin.LOGGER.info("LocalAppearanceStorage initialized at: {}", (Object)this.storageFile);
    }

    public void savePlayerPreferences(UUID playerId) {
        if (this.storageFile == null) {
            return;
        }
        PreferencesData data = this.loadPreferencesData();
        PlayerPreferences prefs = data.players.computeIfAbsent(playerId.toString(), k -> new PlayerPreferences());
        ClientConfig config = ClientConfig.getInstance();
        prefs.lastSkinId = config.activeSkinHash;
        if (!config.activeSkinHash.isEmpty()) {
            LocalAssetManager assetManager = LocalAssetManager.getInstance();
            prefs.lastModelType = assetManager.getSkinModelPreference(config.activeSkinHash);
        } else {
            prefs.lastModelType = "auto";
        }
        this.savePreferencesData(data);
        QuickSkin.LOGGER.debug("Saved preferences for player: {}", (Object)playerId);
    }

    private PreferencesData loadPreferencesData() {
        if (this.storageFile == null || !Files.exists(this.storageFile, new LinkOption[0])) {
            return new PreferencesData();
        }
        try {
            String json = Files.readString(this.storageFile);
            PreferencesData data = (PreferencesData)GSON.fromJson(json, PreferencesData.class);
            return data != null ? data : new PreferencesData();
        }
        catch (IOException e) {
            QuickSkin.LOGGER.error("Failed to load appearance preferences", (Throwable)e);
            return new PreferencesData();
        }
    }

    private void savePreferencesData(PreferencesData data) {
        if (this.storageFile == null) {
            return;
        }
        try {
            String json = GSON.toJson((Object)data);
            Files.writeString(this.storageFile, (CharSequence)json, new OpenOption[0]);
        }
        catch (IOException e) {
            QuickSkin.LOGGER.error("Failed to save appearance preferences", (Throwable)e);
        }
    }

    static {
        GSON = new GsonBuilder().setPrettyPrinting().create();
    }

    public static class PreferencesData {
        public Map<String, PlayerPreferences> players = new HashMap<String, PlayerPreferences>();
    }

    public static class PlayerPreferences {
        public String lastSkinId;
        public String lastModelType;
        public Map<String, String> favorites = new HashMap<String, String>();
    }
}

