/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.common.data;

public enum SkinResolution {
    LEGACY(64, 32, 1),
    STANDARD(64, 64, 1),
    HD_128(128, 128, 2),
    HD_256(256, 256, 4),
    HD_512(512, 512, 8),
    HD_1024(1024, 1024, 16),
    HD_2048(2048, 2048, 32),
    CAPE_128(128, 64, 2),
    CAPE_256(256, 128, 4),
    CAPE_512(512, 256, 8),
    CAPE_1024(1024, 512, 16),
    CAPE_2048(2048, 1024, 32);

    private final int width;
    private final int height;
    private final int scale;

    private SkinResolution(int width, int height, int scale) {
        this.width = width;
        this.height = height;
        this.scale = scale;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getScale() {
        return this.scale;
    }

    public boolean isHD() {
        return this.scale > 1;
    }

    public static SkinResolution fromDimensions(int width, int height) {
        for (SkinResolution res : SkinResolution.values()) {
            if (res.width != width || res.height != height) continue;
            return res;
        }
        return null;
    }

    public String toString() {
        return this.width + "x" + this.height + (String)(this.isHD() ? " (HD " + this.scale + "x)" : "");
    }
}

