/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.common.event;

import com.quickskin.mod.QuickSkin;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class InternalEventBus {
    private static final InternalEventBus INSTANCE = new InternalEventBus();
    private final Map<Class<?>, List<Consumer<?>>> listeners = new ConcurrentHashMap();

    private InternalEventBus() {
    }

    public static InternalEventBus getInstance() {
        return INSTANCE;
    }

    public <T> void register(Class<T> eventType, Consumer<T> listener) {
        this.listeners.computeIfAbsent(eventType, k -> new ArrayList()).add(listener);
        QuickSkin.LOGGER.debug("Registered listener for event: {}", (Object)eventType.getSimpleName());
    }

    public <T> void post(T event) {
        Class<?> eventType = event.getClass();
        List<Consumer<?>> eventListeners = this.listeners.get(eventType);
        if (eventListeners != null && !eventListeners.isEmpty()) {
            QuickSkin.LOGGER.debug("Posting event: {}", (Object)eventType.getSimpleName());
            for (Consumer<?> listener : eventListeners) {
                try {
                    listener.accept(event);
                }
                catch (Exception e) {
                    QuickSkin.LOGGER.error("Error handling event {}", (Object)eventType.getSimpleName(), (Object)e);
                }
            }
        }
    }
}

