/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.common.util;

import com.quickskin.mod.QuickSkin;
import com.quickskin.mod.common.data.SkinResolution;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import javax.imageio.ImageIO;

public class SkinModelDetector {
    public static String detectSkinModel(BufferedImage image) {
        int blue;
        int green;
        int red;
        int alpha;
        int argb;
        int x;
        int y;
        int scale;
        int height;
        if (image == null) {
            return "classic";
        }
        int width = image.getWidth();
        SkinResolution resolution = SkinResolution.fromDimensions(width, height = image.getHeight());
        int n = scale = resolution != null ? resolution.getScale() : 1;
        if (resolution == SkinResolution.LEGACY) {
            return "classic";
        }
        int rightArmX = 54 * scale;
        int rightArmEndX = 56 * scale;
        int rightArmStartY = 20 * scale;
        int rightArmEndY = 32 * scale;
        int leftArmX = 46 * scale;
        int leftArmEndX = 48 * scale;
        int leftArmStartY = 52 * scale;
        int leftArmEndY = 64 * scale;
        int totalPixels = 0;
        int transparentPixels = 0;
        for (y = rightArmStartY; y < rightArmEndY && y < height; ++y) {
            for (x = rightArmX; x < rightArmEndX && x < width; ++x) {
                ++totalPixels;
                argb = image.getRGB(x, y);
                alpha = argb >> 24 & 0xFF;
                red = argb >> 16 & 0xFF;
                green = argb >> 8 & 0xFF;
                blue = argb & 0xFF;
                if (alpha >= 10 && (red != 0 || green != 0 || blue != 0)) continue;
                ++transparentPixels;
            }
        }
        for (y = leftArmStartY; y < leftArmEndY && y < height; ++y) {
            for (x = leftArmX; x < leftArmEndX && x < width; ++x) {
                ++totalPixels;
                argb = image.getRGB(x, y);
                alpha = argb >> 24 & 0xFF;
                red = argb >> 16 & 0xFF;
                green = argb >> 8 & 0xFF;
                blue = argb & 0xFF;
                if (alpha >= 10 && (red != 0 || green != 0 || blue != 0)) continue;
                ++transparentPixels;
            }
        }
        if (totalPixels > 0) {
            float transparentRatio = (float)transparentPixels / (float)totalPixels;
            boolean isSlim = transparentRatio > 0.5f;
            QuickSkin.LOGGER.debug("Skin model detection: {}% transparent pixels -> {}", (Object)((int)(transparentRatio * 100.0f)), (Object)(isSlim ? "slim" : "classic"));
            return isSlim ? "slim" : "classic";
        }
        return "classic";
    }

    public static String detectSkinModel(File file) {
        try {
            BufferedImage image = ImageIO.read(file);
            return SkinModelDetector.detectSkinModel(image);
        }
        catch (Exception e) {
            QuickSkin.LOGGER.error("Failed to detect skin model from file: {}", (Object)file, (Object)e);
            return "classic";
        }
    }

    public static String detectSkinModel(byte[] data) {
        try {
            BufferedImage image = ImageIO.read(new ByteArrayInputStream(data));
            return SkinModelDetector.detectSkinModel(image);
        }
        catch (Exception e) {
            QuickSkin.LOGGER.error("Failed to detect skin model from byte array", (Throwable)e);
            return "classic";
        }
    }

    public static String detectSkinModel(InputStream input) {
        try {
            BufferedImage image = ImageIO.read(input);
            return SkinModelDetector.detectSkinModel(image);
        }
        catch (Exception e) {
            QuickSkin.LOGGER.error("Failed to detect skin model from input stream", (Throwable)e);
            return "classic";
        }
    }
}

