/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.quickskin.mod.QuickSkin;
import com.quickskin.mod.config.ServerConfig;
import com.quickskin.mod.platform.PlatformHelper;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;

public class ClientConfig {
    private static ClientConfig instance;
    private static final Gson GSON;
    public boolean showSkinPreviewOverlay = false;
    public String overlayPosition = "BOTTOM_RIGHT";
    public int previewScale = 30;
    public int guiScale = 1;
    public boolean enablePlayerPreviewCustomization = false;
    public float hudOverlayRotation = 20.0f;
    public int sizeModelPreviewPercentageTitleScreen = 0;
    public int sizeModelPreviewPercentageSkinMenu = 0;
    public int sizeModelPreviewPercentageCapeMenu = 0;
    public int sizeModelPreviewPercentagePauseMenu = 0;
    public int sizeModelPreviewPercentageHudOverlay = 30;
    public int positionOffsetXTitleScreen = 0;
    public int positionOffsetYTitleScreen = 0;
    public int positionOffsetXSkinMenu = 0;
    public int positionOffsetYSkinMenu = 0;
    public int positionOffsetXCapeMenu = 0;
    public int positionOffsetYCapeMenu = 0;
    public int positionOffsetXPauseMenu = 0;
    public int positionOffsetYPauseMenu = 0;
    public int positionOffsetXHudOverlay = 0;
    public int positionOffsetYHudOverlay = 0;
    public float animationSpeed = 1.0f;
    public boolean enableSmoothRotation = true;
    public Map<String, Float> capeAnimationSpeeds = new HashMap<String, Float>();
    public int maxCachedTextures = 100;
    public int networkTimeout = 5000;
    public boolean disableSkinTransparency = false;
    public boolean enableStyledButtons = false;
    public boolean enablePlayerOwnSkinSystem = true;
    public String activeSkinHash = "";
    @Deprecated
    public String activeModelType = "auto";
    public String activeCapeHash = "";
    public String playerOwnSkinHash = "";
    public transient ServerConfig serverOverride = null;

    private ClientConfig() {
    }

    public static ClientConfig getInstance() {
        if (instance == null) {
            instance = ClientConfig.load();
        }
        return instance;
    }

    private static ClientConfig load() {
        Path configPath = ClientConfig.getConfigPath();
        if (Files.exists(configPath, new LinkOption[0])) {
            try {
                String json = Files.readString(configPath);
                ClientConfig config = (ClientConfig)GSON.fromJson(json, ClientConfig.class);
                QuickSkin.LOGGER.info("Loaded client configuration");
                return config;
            }
            catch (Exception e) {
                QuickSkin.LOGGER.error("Failed to load client configuration, using defaults", (Throwable)e);
            }
        }
        ClientConfig config = new ClientConfig();
        config.save();
        return config;
    }

    public void save() {
        Path configPath = ClientConfig.getConfigPath();
        try {
            Files.createDirectories(configPath.getParent(), new FileAttribute[0]);
            String json = GSON.toJson((Object)this);
            Files.writeString(configPath, (CharSequence)json, new OpenOption[0]);
        }
        catch (IOException e) {
            QuickSkin.LOGGER.error("Failed to save client configuration", (Throwable)e);
        }
    }

    private static Path getConfigPath() {
        return PlatformHelper.getConfigDirectory().resolve("quickskin-client.json");
    }

    public static void reload() {
        instance = ClientConfig.load();
    }

    public void applyServerOverride(ServerConfig serverConfig) {
        this.serverOverride = serverConfig;
        if (serverConfig != null) {
            QuickSkin.LOGGER.info("Applied server configuration override");
        } else {
            QuickSkin.LOGGER.info("Cleared server configuration override");
        }
    }

    public ServerConfig getServerOverride() {
        return this.serverOverride;
    }

    public boolean shouldDisableSkinTransparency() {
        if (this.disableSkinTransparency) {
            return true;
        }
        return this.serverOverride != null && this.serverOverride.disableSkinTransparency;
    }

    @Deprecated
    public float getAnimationSpeed() {
        return Math.max(0.01f, Math.min(this.animationSpeed, 10.0f));
    }

    public float getCapeAnimationSpeed(String capeId) {
        Float speed;
        if (capeId == null || capeId.isEmpty()) {
            return 1.0f;
        }
        if (this.capeAnimationSpeeds == null) {
            this.capeAnimationSpeeds = new HashMap<String, Float>();
        }
        if ((speed = this.capeAnimationSpeeds.get(capeId)) == null) {
            return 1.0f;
        }
        return Math.max(0.01f, Math.min(speed.floatValue(), 10.0f));
    }

    public void setCapeAnimationSpeed(String capeId, float speed) {
        if (capeId == null || capeId.isEmpty()) {
            return;
        }
        if (this.capeAnimationSpeeds == null) {
            this.capeAnimationSpeeds = new HashMap<String, Float>();
        }
        float clampedSpeed = Math.max(0.01f, Math.min(speed, 10.0f));
        this.capeAnimationSpeeds.put(capeId, Float.valueOf(clampedSpeed));
        QuickSkin.LOGGER.debug("Set animation speed for cape {}: {}", (Object)capeId, (Object)Float.valueOf(clampedSpeed));
    }

    static {
        GSON = new GsonBuilder().setPrettyPrinting().create();
    }
}

