/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.quickskin.mod.QuickSkin;
import com.quickskin.mod.platform.PlatformHelper;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class ServerConfig {
    private static ServerConfig instance;
    private static final Gson GSON;
    public boolean disableSkinTransparency = false;
    public int skinChangeCooldownSeconds = 0;

    private ServerConfig() {
    }

    public static ServerConfig getInstance() {
        if (instance == null) {
            instance = ServerConfig.load();
        }
        return instance;
    }

    private static ServerConfig load() {
        Path configPath = ServerConfig.getConfigPath();
        if (Files.exists(configPath, new LinkOption[0])) {
            try {
                String json = Files.readString(configPath);
                ServerConfig config = (ServerConfig)GSON.fromJson(json, ServerConfig.class);
                QuickSkin.LOGGER.info("Loaded server configuration");
                return config;
            }
            catch (Exception e) {
                QuickSkin.LOGGER.error("Failed to load server configuration, using defaults", (Throwable)e);
            }
        }
        ServerConfig config = new ServerConfig();
        config.save();
        return config;
    }

    public void save() {
        Path configPath = ServerConfig.getConfigPath();
        try {
            Files.createDirectories(configPath.getParent(), new FileAttribute[0]);
            String json = GSON.toJson((Object)this);
            Files.writeString(configPath, (CharSequence)json, new OpenOption[0]);
            QuickSkin.LOGGER.debug("Saved server configuration");
        }
        catch (IOException e) {
            QuickSkin.LOGGER.error("Failed to save server configuration", (Throwable)e);
        }
    }

    private static Path getConfigPath() {
        return PlatformHelper.getConfigDirectory().resolve("quickskin-server.json");
    }

    public static void reload() {
        instance = ServerConfig.load();
    }

    public String toJson() {
        return GSON.toJson((Object)this);
    }

    public static ServerConfig fromJson(String json) {
        try {
            return (ServerConfig)GSON.fromJson(json, ServerConfig.class);
        }
        catch (Exception e) {
            QuickSkin.LOGGER.error("Failed to parse server config from JSON", (Throwable)e);
            return new ServerConfig();
        }
    }

    static {
        GSON = new GsonBuilder().setPrettyPrinting().create();
    }
}

