/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.mixin;

import com.quickskin.mod.client.services.PlayerAppearanceService;
import com.quickskin.mod.common.data.PlayerAppearance;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.resources.ResourceLocation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractClientPlayer.class})
public class MixinAbstractClientPlayer {
    @Inject(method={"getSkinTextureLocation"}, at={@At(value="HEAD")}, cancellable=true)
    private void quickskin$getSkinTextureLocation(CallbackInfoReturnable<ResourceLocation> cir) {
        ResourceLocation customSkin;
        AbstractClientPlayer self = (AbstractClientPlayer)this;
        PlayerAppearanceService service = PlayerAppearanceService.getInstance();
        if (service.hasActiveSkin(self.m_20148_()) && (customSkin = service.getSkinLocation(self.m_20148_())) != null) {
            cir.setReturnValue((Object)customSkin);
        }
    }

    @Inject(method={"getModelName"}, at={@At(value="HEAD")}, cancellable=true)
    private void quickskin$getModelName(CallbackInfoReturnable<String> cir) {
        String customModel;
        AbstractClientPlayer self = (AbstractClientPlayer)this;
        PlayerAppearanceService service = PlayerAppearanceService.getInstance();
        if ((service.hasActiveSkin(self.m_20148_()) || service.hasModelOverride(self.m_20148_())) && (customModel = service.getModelName(self.m_20148_())) != null) {
            cir.setReturnValue((Object)customModel);
        }
    }

    @Inject(method={"getCloakTextureLocation"}, at={@At(value="HEAD")}, cancellable=true)
    private void quickskin$getCloakTextureLocation(CallbackInfoReturnable<ResourceLocation> cir) {
        AbstractClientPlayer self = (AbstractClientPlayer)this;
        PlayerAppearanceService service = PlayerAppearanceService.getInstance();
        if (service.hasActiveCape(self.m_20148_())) {
            PlayerAppearance appearance = service.getAppearance(self.m_20148_());
            if (appearance != null && ("__NONE__".equals(appearance.getCapeId()) || appearance.getCapeId().isEmpty())) {
                cir.setReturnValue(null);
                return;
            }
            ResourceLocation customCape = service.getCapeLocation(self.m_20148_());
            cir.setReturnValue((Object)customCape);
        }
    }
}

