/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.networking;

import com.quickskin.mod.QuickSkin;
import com.quickskin.mod.client.gui.screen.SettingsScreen;
import com.quickskin.mod.client.services.AnimatedTextureManager;
import com.quickskin.mod.client.services.CooldownService;
import com.quickskin.mod.client.services.LocalAssetManager;
import com.quickskin.mod.client.services.PlayerAppearanceService;
import com.quickskin.mod.client.storage.ClientAnimationMetadataCache;
import com.quickskin.mod.client.storage.NetworkTextureCache;
import com.quickskin.mod.client.storage.TextureChunkReceiver;
import com.quickskin.mod.common.data.AnimationMetadata;
import com.quickskin.mod.common.data.PlayerAppearance;
import com.quickskin.mod.common.data.PlayerAppearanceRepository;
import com.quickskin.mod.common.event.InternalEventBus;
import com.quickskin.mod.common.event.ServerConfigSyncEvent;
import com.quickskin.mod.config.ClientConfig;
import com.quickskin.mod.config.ServerConfig;
import com.quickskin.mod.networking.NetworkSyncService;
import com.quickskin.mod.networking.packets.PacketHelper;
import dev.architectury.networking.NetworkManager;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.UUID;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ClientNetworkHandler {
    private static boolean pendingTransparencyReload = false;

    public static void handleSyncAppearance(FriendlyByteBuf buf, NetworkManager.PacketContext context) {
        UUID playerId = PacketHelper.readPlayerId(buf);
        String skinId = PacketHelper.readString(buf);
        String capeId = PacketHelper.readString(buf);
        String model = PacketHelper.readString(buf);
        context.queue(() -> {
            QuickSkin.LOGGER.info("Received appearance sync for player {}: skin={}, cape={}, model={}", new Object[]{playerId, skinId, capeId, model});
            PlayerAppearanceService.getInstance().applyLook(playerId, skinId, capeId, model);
        });
    }

    public static void handleSendTexture(FriendlyByteBuf buf, NetworkManager.PacketContext context) {
        String textureType = PacketHelper.readString(buf);
        String hash = PacketHelper.readString(buf);
        byte[] imageData = PacketHelper.readByteArray(buf);
        context.queue(() -> {
            QuickSkin.LOGGER.info("Received {} texture from server: {} (size: {} bytes)", new Object[]{textureType, hash, imageData.length});
            NetworkTextureCache.getInstance().storeTexture(hash, textureType, imageData);
            QuickSkin.LOGGER.debug("Cached {} texture from server: {}", (Object)textureType, (Object)hash);
        });
    }

    public static void handleSendAnimationMetadata(FriendlyByteBuf buf, NetworkManager.PacketContext context) {
        String hash = PacketHelper.readString(buf);
        String metadataJson = PacketHelper.readString(buf);
        context.queue(() -> {
            QuickSkin.LOGGER.info("Received animation metadata for: {}", (Object)hash);
            try {
                AnimationMetadata metadata = AnimationMetadata.fromJson(metadataJson);
                ClientAnimationMetadataCache.getInstance().storeMetadata(hash, metadata);
                Path cacheDir = LocalAssetManager.getInstance().getCacheDirectory();
                Path metadataPath = cacheDir.resolve(hash + ".json");
                Files.writeString(metadataPath, (CharSequence)metadataJson, new OpenOption[0]);
                QuickSkin.LOGGER.debug("Saved animation metadata: {} frames, {} ms total duration", (Object)metadata.frameCount(), (Object)metadata.getTotalDuration());
                ClientNetworkHandler.registerNetworkCapeAnimation(hash, metadata);
                ClientNetworkHandler.refreshPlayersUsingTexture(hash);
            }
            catch (Exception e) {
                QuickSkin.LOGGER.error("Failed to save animation metadata for: {}", (Object)hash, (Object)e);
            }
        });
    }

    private static void registerNetworkCapeAnimation(String hash, AnimationMetadata metadata) {
        try {
            ResourceLocation textureLocation = NetworkTextureCache.getInstance().getTextureLocation(hash);
            if (textureLocation == null) {
                QuickSkin.LOGGER.warn("Cannot register animation for {}: texture not in network cache", (Object)hash);
                return;
            }
            byte[] textureData = NetworkTextureCache.getInstance().getTextureData(hash);
            if (textureData == null) {
                QuickSkin.LOGGER.warn("Cannot register animation for {}: texture data not available", (Object)hash);
                return;
            }
            ByteArrayInputStream bais = new ByteArrayInputStream(textureData);
            BufferedImage atlasImage = ImageIO.read(bais);
            if (atlasImage == null) {
                QuickSkin.LOGGER.warn("Cannot register animation for {}: failed to read image", (Object)hash);
                return;
            }
            String animationId = "cape_" + hash;
            String capeId = "local_cape:" + hash;
            AnimatedTextureManager animManager = AnimatedTextureManager.getInstance();
            if (!animManager.isAnimated(animationId)) {
                animManager.registerAnimation(animationId, capeId, textureLocation, atlasImage, metadata);
                QuickSkin.LOGGER.info("Registered animation for network cape: {} ({} frames)", (Object)hash, (Object)metadata.frameCount());
            }
        }
        catch (Exception e) {
            QuickSkin.LOGGER.error("Failed to register animation for network cape: {}", (Object)hash, (Object)e);
        }
    }

    private static void refreshPlayersUsingTexture(String hash) {
        QuickSkin.LOGGER.debug("Animation metadata received for {}, will be applied when cape is loaded", (Object)hash);
    }

    public static void handleSyncServerConfig(FriendlyByteBuf buf, NetworkManager.PacketContext context) {
        String configJson = PacketHelper.readString(buf);
        context.queue(() -> {
            Minecraft mc;
            QuickSkin.LOGGER.info("Received server config sync");
            ClientConfig clientConfig = ClientConfig.getInstance();
            ServerConfig oldServerConfig = clientConfig.getServerOverride();
            boolean oldTransparencySetting = oldServerConfig != null && oldServerConfig.disableSkinTransparency;
            ServerConfig serverConfig = ServerConfig.fromJson(configJson);
            boolean newTransparencySetting = serverConfig.disableSkinTransparency;
            clientConfig.applyServerOverride(serverConfig);
            InternalEventBus.getInstance().post(new ServerConfigSyncEvent(!serverConfig.disableSkinTransparency));
            QuickSkin.LOGGER.debug("Server config override applied: disableSkinTransparency={}, skinChangeCooldownSeconds={}", (Object)serverConfig.disableSkinTransparency, (Object)serverConfig.skinChangeCooldownSeconds);
            if (oldTransparencySetting != newTransparencySetting) {
                mc = Minecraft.m_91087_();
                boolean isInSettingsScreen = mc.f_91080_ instanceof SettingsScreen;
                if (mc.f_91080_ == null || !isInSettingsScreen) {
                    QuickSkin.LOGGER.info("Server transparency setting changed, reloading textures immediately (screen: {})", (Object)(mc.f_91080_ != null ? mc.f_91080_.getClass().getSimpleName() : "null"));
                    PlayerAppearanceService.getInstance().reloadSkinsForTransparencyChange();
                } else {
                    QuickSkin.LOGGER.info("Server transparency setting changed, marking reload as pending");
                    pendingTransparencyReload = true;
                }
            }
            mc = Minecraft.m_91087_();
            if (mc.f_91074_ != null) {
                UUID playerId = mc.f_91074_.m_20148_();
                PlayerAppearance currentAppearance = PlayerAppearanceRepository.getInstance().getAppearance(playerId);
                if (currentAppearance != null) {
                    QuickSkin.LOGGER.info("Syncing current appearance to server after config received");
                    NetworkSyncService.getInstance().syncAppearance(playerId, currentAppearance.getSkinId(), currentAppearance.getCapeId(), currentAppearance.getModel());
                }
            }
        });
    }

    public static void executePendingTransparencyReload() {
        if (pendingTransparencyReload) {
            QuickSkin.LOGGER.info("Executing pending transparency reload");
            PlayerAppearanceService.getInstance().reloadSkinsForTransparencyChange();
            pendingTransparencyReload = false;
        }
    }

    public static void handleSendTextureChunk(FriendlyByteBuf buf, NetworkManager.PacketContext context) {
        String hash = buf.m_130277_();
        int chunkIndex = buf.readInt();
        int totalChunks = buf.readInt();
        byte[] chunkData = buf.m_130052_();
        context.queue(() -> {
            QuickSkin.LOGGER.debug("Received texture chunk {}/{} for: {} (size: {} bytes)", new Object[]{chunkIndex + 1, totalChunks, hash, chunkData.length});
            if (chunkData.length > 32768) {
                QuickSkin.LOGGER.warn("Received oversized chunk: {} bytes (max: 32KB)", (Object)chunkData.length);
                return;
            }
            TextureChunkReceiver.getInstance().receiveChunk(hash, chunkIndex, totalChunks, chunkData);
        });
    }

    public static void handleCooldownUpdate(FriendlyByteBuf buf, NetworkManager.PacketContext context) {
        long cooldownEndTime = buf.readLong();
        context.queue(() -> {
            QuickSkin.LOGGER.debug("Received cooldown update. Ends at: {}", (Object)cooldownEndTime);
            CooldownService.getInstance().setCooldownEndTime(cooldownEndTime);
        });
    }
}

