/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.networking.packets;

import io.netty.buffer.Unpooled;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;

public class PacketHelper {
    public static FriendlyByteBuf createUploadTexturePacket(UUID playerId, String textureType, byte[] imageData) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.m_130077_(playerId);
        buf.m_130070_(textureType);
        buf.m_130087_(imageData);
        return buf;
    }

    public static FriendlyByteBuf createUpdateAppearancePacket(UUID playerId, String skinId, String capeId, String model) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.m_130077_(playerId);
        buf.m_130070_(skinId != null ? skinId : "");
        buf.m_130070_(capeId != null ? capeId : "");
        buf.m_130070_(model != null ? model : "classic");
        return buf;
    }

    public static FriendlyByteBuf createSyncAppearancePacket(UUID playerId, String skinId, String capeId, String model) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.m_130077_(playerId);
        buf.m_130070_(skinId != null ? skinId : "");
        buf.m_130070_(capeId != null ? capeId : "");
        buf.m_130070_(model != null ? model : "classic");
        return buf;
    }

    public static FriendlyByteBuf createRequestTexturePacket(UUID playerId, String textureType, String hash) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.m_130077_(playerId);
        buf.m_130070_(textureType);
        buf.m_130070_(hash);
        return buf;
    }

    public static FriendlyByteBuf createSendTexturePacket(String textureType, String hash, byte[] imageData) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.m_130070_(textureType);
        buf.m_130070_(hash);
        buf.m_130087_(imageData);
        return buf;
    }

    public static FriendlyByteBuf createSyncServerConfigPacket(String configJson) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.m_130070_(configJson);
        return buf;
    }

    public static FriendlyByteBuf createSendAnimationMetadataPacket(String hash, String metadataJson) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.m_130070_(hash);
        buf.m_130070_(metadataJson);
        return buf;
    }

    public static UUID readPlayerId(FriendlyByteBuf buf) {
        return buf.m_130259_();
    }

    public static String readString(FriendlyByteBuf buf) {
        return buf.m_130277_();
    }

    public static byte[] readByteArray(FriendlyByteBuf buf) {
        return buf.m_130052_();
    }

    public static boolean readBoolean(FriendlyByteBuf buf) {
        return buf.readBoolean();
    }
}

