/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.server.storage;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Nullable;

public class TextureChunkAssembler {
    private static TextureChunkAssembler instance;
    private final Map<String, ChunkAssembly> assemblies = new ConcurrentHashMap<String, ChunkAssembly>();

    private TextureChunkAssembler() {
    }

    public static TextureChunkAssembler getInstance() {
        if (instance == null) {
            instance = new TextureChunkAssembler();
        }
        return instance;
    }

    public byte @Nullable [] addChunk(String hash, int chunkIndex, int totalChunks, byte[] chunkData) {
        ChunkAssembly assembly = this.assemblies.computeIfAbsent(hash, k -> new ChunkAssembly(totalChunks));
        assembly.addChunk(chunkIndex, chunkData);
        if (assembly.isComplete()) {
            byte[] completeData = assembly.assemble();
            this.assemblies.remove(hash);
            return completeData;
        }
        return null;
    }

    private static class ChunkAssembly {
        private final byte[][] chunks;
        private int receivedChunks = 0;

        ChunkAssembly(int totalChunks) {
            this.chunks = new byte[totalChunks][];
        }

        void addChunk(int index, byte[] data) {
            if (index >= 0 && index < this.chunks.length && this.chunks[index] == null) {
                this.chunks[index] = data;
                ++this.receivedChunks;
            }
        }

        boolean isComplete() {
            return this.receivedChunks == this.chunks.length;
        }

        byte[] assemble() {
            int totalSize = 0;
            for (byte[] chunk : this.chunks) {
                totalSize += chunk.length;
            }
            byte[] result = new byte[totalSize];
            int offset = 0;
            for (byte[] chunk : this.chunks) {
                System.arraycopy(chunk, 0, result, offset, chunk.length);
                offset += chunk.length;
            }
            return result;
        }
    }
}

